const path = require('path');
const { app, BrowserWindow } = require('electron');

// 禁用安全限制
app.commandLine.appendSwitch('no-sandbox')
app.commandLine.appendSwitch('disable-gpu')
process.env.ELECTRON_DISABLE_SANDBOX = '1'

function createWindow() {
  console.log("正在创建独立桌面窗口...");
  
  // 创建浏览器窗口
  const win = new BrowserWindow({
    width: 1200,
    height: 800,
    // 确保这些设置正确
    title: "Discuz 聊天客户端",
    icon: path.join(__dirname, 'icon.png'), // 准备一个图标
    webPreferences: {
      nodeIntegration: true,
      contextIsolation: false
    }
  });
  
  // 加载应用时隐藏默认菜单
  win.setMenu(null);
  
  // 设置窗口标题
  win.on('page-title-updated', (e) => {
    e.preventDefault(); // 防止页面标题覆盖窗口标题
  });
  
  // 加载您的 Discuz 插件
  win.loadURL('http://qazz.sseuu.com/plugin.php?id=qingqiu');
  
  // 窗口就绪时显示
  win.on('ready-to-show', () => {
    win.show();
    console.log("独立窗口已显示");
  });
  win.on('show', () => console.log("窗口已显示"));
  win.on('hide', () => console.log("窗口已隐藏"));
  win.on('focus', () => console.log("窗口获得焦点"));
  win.on('blur', () => console.log("窗口失去焦点"));
  win.on('minimize', () => console.log("窗口最小化"));
  win.on('maximize', () => console.log("窗口最大化"));
  win.on('restore', () => console.log("窗口从最小化恢复"));
}

app.whenReady().then(createWindow)